# Trusted Signatures CLI

A command-line tool for digitally signing PDFs using a certificate trusted by Adobe Acrobat (AATL-compliant) and eIDAS, without uploading your documents or managing cryptography. It manages the many intracacies involved in PDF manipulation for you, while maintaining a simple, easy-to-understand interface, saving you and your team countless hours. 

## ✨ What It Does
- Prepares a placeholder for a digital signature in your PDF
- Computes a SHA-256 hash of the document
- Authenticates via API key and securely requests a signature from the Trusted Signatures API
- Embeds the returned PKCS#7 signature (CMS) into your PDF
- Produces a valid, verifiable, tamper-evident signature

No document contents or metadata ever leave your machine — only the cryptographic digest is sent to the signing API.

---

## 🔧 Installation
Binary releases available for amd64 and arm64 architecures on macOS, Linux, and Windows (amd64-only).

```bash
curl -LO https://trusted-signatures.com/downloads/sign-pdf-v1.2.3-macos-arm64.tar.gz
tar -xzf sign-pdf-v1.2.3-macos.tar.gz
sudo mv sign-pdf /usr/local/bin # or elsewhere on your PATH for Windows users
```

---

## ✅ Usage
```bash
sign-pdf \
  --input input.pdf \
  --output signed.pdf \
  --apikeyid 12345-6789-0123456 \
  --apikey 0001020304... \
```

Use `--help` for full CLI options.

### Optional flags:
- `--apikeyid`, `-d`: Your API key ID from Trusted Signatures; may be set by environment variable
- `--apikey`, `-k`: Your API key from Trusted Signatures; may be set by environment variable
- `--input`, `-i`: File path to save the signed PDF; defaults to stdin
- `--output`, `-o`: File path to save the signed PDF; defaults to stdout
- `--tsa`, `-t`: Embed a TSA Timestamp (takes longer to process); not included by default
- `--ltv`, `-l`: Embed Long Term Validation (LTV) data (sets `--tsa`)
- `--limit-changes <policy>`: Limit changes in subsequent revisions of the document. Policies: `no-changes` (PDF P 1), `allow-forms` (PDF P 2), `allow-comments` (PDF P 3); no limits by default
- `--endpoint`, `-e`: Your API endpoint; defaults to https://api.trusted-signatures.com
- `--licenses`: Print the licenses of the dependencies used by this application
- `--version`: Print the version of this application

### Environment variables:
- `TS_API_KEY`: Your API key from Trusted Signatures
- `TS_API_KEY_ID`: Your API key ID from Trusted Signatures

### API Key:
The API Key is how we authenticate that a signing request came from you. It is imperative that you store the key securely; if you even suspect that
someone unauthorized might have accessed your API key, disable it immediately and generate a new one. API keys are available at trusted-signatures.com free of charge, and are time-limited and may be limited to your network CIDR as well. 

### Networking:
The CLI sends an SHA-256 digest of the PDF along with an authentication token to our servers, which generate the CMS. The CLI must have outbound
internet access to our API (https://api.trusted-signatures.com) on port 443. 

### Clock:
To keep your API Key secure, your computer's clock must be set accurately. Most operating systems do this automatically, but if the clock is 
off by more than five minutes, the CLI signing request will be rejected. 

---

## 🔒 Security & Trust
- **You never upload your document** — only a SHA-256 hash is sent, so the service may be used on confidential documents
- **Signatures are backed by an AATL/EUTL-compliant certificate** 
- **Signatures are cryptographically verifiable** and tamper-evident by anyone with Adobe Acrobat

### Identity fields
The signed PDF will show:
- `/Name`: `Trusted Signatures` (or the name of your business, if you use a custom certificate)
- `/Reason`: `This document was digitally sealed by Trusted Signatures. We do not verify or endorse the document content; the seal was applied at the request of a Trusted Signatures customer.`
- `/Location`: `trusted-signatures.com`

Users may not override the signer identity — this protects the legal trust model of AATL certificates. 

### ✍️ Certification Seals and Limiting Changes
If you are the original producer of the PDF you're sealing, (meaning no one else has applied a digital signature to it), you should apply a certification seal, which identifies your origanization as the party that created the document, and limits the changes allowed in the document. The CLI makes this easy with the `--limit-changes <policy>` argument.

There are three policies permitted for the `--limit-changes` argument, based upon the PDF specification:
| **Value** | **Meaning** |
| --- | --- |
| `no-changes` | Any change will invalidate the seal |
| `allow-forms` | Fields and signatures may be filled in; additional pages may be added. |
| `allow-comments` | Fields and signatures may be filled in; comments and additional pages may be added. |

---

## 🛡️ Disclaimer in Signature
The following disclaimer will be embedded in the signature metadata:
> *This document was digitally sealed by Trusted Signatures. We do not verify or endorse the document content; the seal was applied at the request of a Trusted Signatures customer.*

This helps maintain legal clarity and complies with certificate authority policies. This disclaimer may be changed if you seal with an OV certificate for your organization. 

---

## 📄 Learn More
- [trusted-signatures.com](https://trusted-signatures.com)
- [CLI documentation](https://trusted-signatures.com/docs/cli/)
- [Contact support](mailto:support@trusted-signatures.com)

---

## 🚀 Coming Soon
- Custom OV certificates for your business
- Audit trail dashboard

---

**Build trust into your PDFs — without building crypto infrastructure.**
